<!DOCTYPE html>

<!--

Aiden's Professional Portfolio
File Name: index.php
Date: 04/17/2021

-->

<html lang="en">

<head>
    <meta name="keywords" content="Front End Developer, Web Designer, Front End Web Design, UX/UI, Web Developer">
    <meta name="description" content="Professional Front End Web Developer Portfolio">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">
    <meta name="author" content="Aiden Mace">
    <title>Front End Developer &amp; Design</title>
    <!-- Add Title Logo Icon -->
    <link rel = "icon" href="images/title-logo.png" 
    type = "image/x-icon">
    <link rel="stylesheet" href="css/template.css" type="text/css">
    <script src="https://www.google.com/recaptcha/api.js"></script>
    <!-- Load an icon library to show a hamburger menu (bars) on small screens -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+TC&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+TC&family=Prompt:ital@1&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Comfortaa&family=Noto+Sans+TC&family=Prompt:ital@1&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Ubuntu&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Titillium+Web&family=Ubuntu&display=swap" rel="stylesheet">
</head>
    
<body>
    
<?php include ('./includes/nav.inc.html.php')

?>
    
<main>
    
<?php include ('./includes/header.php')

?>
    
<div class="container">
Previous Projects
<br>
<div class="line"><hr></div>
<br>
<br><br>
</div>
    
<div id="sliderBackground">
<div class="container2">
  <ul id="slides">
    <li class="slide showing"></li>
    <li class="slide"></li>
    <li class="slide"></li>
    <li class="slide"></li>
    <li class="slide"></li>
    <li class="slide"></li>
</ul>
  
<div class="buttons">
    <button class="controls" id="previous">&lt;</button>

    <button class="controls" id="pause">&#10074;&#10074;</button>

    <button class="controls" id="next">&gt;</button>
</div>

</div>
</div>   
<br><br>
<br>
<br>
<br>
<!--h2 Text-->
<h2>About</h2>
<div class="line"><hr></div>

<br>

<div class="aboutMe">
<p>Hi! My name is Aiden, and I live in Portland Oregon. I am a front end developer &amp; designer who is skilled in a variety of other areas. In my free time I enjoy spending time with my family, traveling, and enjoying the Oregon outdoors.</p>
<br>
</div>
    
<div id="Portfolio" ><h2>Portfolio</h2></div>
<div class="line"><hr></div>
<br>   
<br><br>
<br>
    
<div id="galleryBackground">
<br><br>
<div class="zoom"> 
    <div class="responsive">
        <div class="gallery">
            <a target="_blank" href="https://mindfulnesstherapyservice.com">
            <img src="images/desiree-site.png" alt="Therapist Website Image" width="500" height="400">
            </a>
        <div class="desc">Live site</div>
    </div>
</div> 
</div>

<div class="zoom"> 
    <div class="responsive">
        <div class="gallery">
            <a target="_blank" href="http://greatestdestinationweddings.com">
            <img src="images/GTW-crop.png" alt="Wedding Services Website Image" width="500" height="400">
            </a>
        <div class="desc">Live site</div>
        </div>
    </div>
</div>
    
<div class="zoom">    
    <div class="responsive">
        <div class="gallery">
            <a target="_blank" href="">
            <img src="images/Outside-The-Box.png" alt="School Project Website Image " width="500" height="400">
            </a>
        <div class="desc">School Project - Mockup</div>
        </div>
    </div>
</div>
    
<div class="zoom">   
    <div class="responsive">
        <div class="gallery">
            <a target="_blank" href="https://lanashea.com">
            <img src="images/lanashea-site.png" alt="Lana Shea Music Website Image" width="500" height="400">
            </a>
        <div class="desc">Live site</div>
        </div>
    </div>
             
</div>

</div>
        
<div class="clearfix"></div>
<br><br>
<br><br>
    
<h2>Areas Of Skill</h2>
<div class="line"><hr></div>
<br>   
      
<div class="skills"> 
<ul>
    <li>Javascript</li>
    <li>HTML5</li>
    <li>CSS3</li>
    <li>jQuery</li>
    <li>UX/UI</li>
    <li>PHP</li>
    <li>Web APIs</li>
    <li>SEO</li>
    <li>SQL</li>
    <li>Vue.js</li>
    <li>Github</li>
    <li>JIRA</li>
</ul>  
  
</div><br>
    
<br>
 <div id="Contact">   
     <h2>Contact</h2></div>   
<div class="line"><hr></div>
<br>       
  
<div class="contact-form">
<h2>Message Me</h2>

<form method="post" action="">
    
    <input type="text" name="name" placeholder="Your Name" required>
    <input type="text" name="phone" placeholder="Phone Number" required>
    <input type="email" name="email" placeholder="Your Email" required>
    <textarea name="message" placeholder="Your Message" required></textarea>
    
<div class="g-recaptcha" data-sitekey="6LdaCRMbAAAAAPU84bcP-lDOyaSnXNbRcXn5kpP-"></div>
    
<input type="submit" name="submit" value="Send Message" class="submit-btn">

</form>
    
<div class="status">
  
<?php 
   if(isset($_POST['submit']))
   {
       $User_name = $_POST['name'];
       $phone = $_POST['phone'];
       $user_email = $_POST['email'];
       $user_message = $_POST['message'];
       
       $email_from = 'noreply@aidenmace.com';
       $email_subject = "New Form Submission";
       $email_body = "Name: $User_name.\n".
                        "Phone Number: $phone.\n".
                        "Email Id: $user_email.\n".
                        "User Message: $user_message.\n";
       
       $to_email = "aiden.mace@pcc.edu";
       $headers = "From: $email_from \r\n";
       $headers = "Reply-To: $user_email\r\n";
       
       $secretKey = "6LdaCRMbAAAAANGM78pPBKt8Z5o5fE-tqIPDaW0-";
       $responseKey = $_POST['g-recaptcha-response'];
       $UserIP = $_SERVER['REMOTE_ADDR'];
       $url = "https://www.google.com/recaptcha/api/siteverify?secret=$secretKey&response=$responseKey&remoteip=$UserIP";
       
       $response = file_get_contents($url);
       $response = json_decode($response);
       
       if ($response->success)
       {
           mail($to_email,$email_subject,$email_body,$headers);
           echo "Message Sent Successfully";
       }
       else
       {
           echo "<span>Invalid Captcha, Please Try Again</span>";
       }
   }
    
?>

    </div>
    
</div>

<br>
    
<button onclick="topFunction()" id="myBtn" title="Go to top">&#129033;</button>

<script>
//Get button
var mybutton = document.getElementById("myBtn");

// Button appears at 20px from the top of the document when scroll down
window.onscroll = function() {scrollFunction()};

function scrollFunction() {
  if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
    mybutton.style.display = "block";
  } else {
    mybutton.style.display = "none";
  }
}

// When the user clicks on the button, scroll to the top of the document
function topFunction() {
  document.body.scrollTop = 0;
  document.documentElement.scrollTop = 0;
}
</script>  
    
 <!--Comment the PHP Form out until functional-->
    
<?php //include ('./contact/index.php')?>    
      
</main>
    
<?php include ('./includes/footer.php')

?>

<?php include ('./includes/footerPageLinks.php')

?>
   
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script src="scripts/slider.js"></script> 
<script src="scripts/slideOut.js"></script>      
        


</body>
    
</html>